/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.SharedConstants;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.status.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerStatusPacketListener;
import net.minecraft.network.protocol.status.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.event.Event;
import org.magmafoundation.magma.craftbukkit.ServerListPingEventImpl;
import org.spigotmc.SpigotConfig;

public class ServerStatusPacketListenerImpl
implements ServerStatusPacketListener {
    private static final Component f_10081_ = new TranslatableComponent("multiplayer.status.request_handled");
    private final MinecraftServer f_10082_;
    private final Connection f_10083_;
    private boolean f_10084_;

    public ServerStatusPacketListenerImpl(MinecraftServer p_10087_, Connection p_10088_) {
        this.f_10082_ = p_10087_;
        this.f_10083_ = p_10088_;
    }

    public void m_7026_(Component p_10091_) {
    }

    public Connection m_6198_() {
        return this.f_10083_;
    }

    public void m_6733_(ServerboundStatusRequestPacket p_10095_) {
        if (this.f_10084_) {
            this.f_10083_.m_129507_(f_10081_);
        } else {
            this.f_10084_ = true;
            ServerListPingEventImpl event = new ServerListPingEventImpl(this.f_10083_, this.f_10082_);
            this.f_10082_.server.getPluginManager().callEvent((Event)event);
            List<Object> profiles = new ArrayList<GameProfile>(event.getPlayers().length);
            for (Object player : event.getPlayers()) {
                if (player == null) continue;
                ServerPlayer entityPlayer = (ServerPlayer)player;
                if (entityPlayer.m_184128_()) {
                    profiles.add(entityPlayer.m_36316_());
                    continue;
                }
                profiles.add(MinecraftServer.f_195496_);
            }
            ServerStatus.Players playerSample = new ServerStatus.Players(event.getMaxPlayers(), profiles.size());
            if (!this.f_10082_.m_183306_()) {
                if (!profiles.isEmpty()) {
                    Collections.shuffle(profiles);
                    profiles = profiles.subList(0, Math.min(profiles.size(), SpigotConfig.playerSample));
                }
                playerSample.m_134924_(profiles.toArray(new GameProfile[profiles.size()]));
            }
            ServerStatus ping = new ServerStatus();
            ping.m_134906_(event.icon.value);
            ping.m_134908_(CraftChatMessage.fromString((String)event.getMotd(), (boolean)true)[0]);
            ping.m_134910_(playerSample);
            int version = SharedConstants.m_183709_().getProtocolVersion();
            ping.m_134912_(new ServerStatus.Version(this.f_10082_.m_130001_() + " " + this.f_10082_.m_7630_(), version));
            ping.setForgeData(this.f_10082_.m_129928_().getForgeData());
            this.f_10083_.m_129512_(new ClientboundStatusResponsePacket(ping));
        }
    }

    public void m_7883_(ServerboundPingRequestPacket p_10093_) {
        this.f_10083_.m_129512_((Packet<?>)new ClientboundPongResponsePacket(p_10093_.m_134998_()));
        this.f_10083_.m_129507_(f_10081_);
    }
}

